document.addEventListener('DOMContentLoaded', function() {
    // Configurar el canvas de firma
    const canvas = document.getElementById('signature-pad');
    const signaturePad = new SignaturePad(canvas, {
        backgroundColor: 'rgba(255, 255, 255, 0)',
        penColor: '#4776e6'
    });
    
    // Ajustar canvas en dispositivos con alta densidad de píxeles
    function resizeCanvas() {
        const ratio = Math.max(window.devicePixelRatio || 1, 1);
        canvas.width = canvas.offsetWidth * ratio;
        canvas.height = canvas.offsetHeight * ratio;
        canvas.getContext('2d').scale(ratio, ratio);
        signaturePad.clear(); // Limpiar en resize
    }
    
    window.addEventListener('resize', resizeCanvas);
    resizeCanvas();
    
    // Botón Limpiar
    document.getElementById('clear-signature').addEventListener('click', function() {
        signaturePad.clear();
        document.getElementById('signature-preview').innerHTML = '';
    });
    
    // Botón Guardar Firma
    document.getElementById('save-signature').addEventListener('click', function() {
        if (signaturePad.isEmpty()) {
            alert('Por favor, proporcione su firma primero.');
            return;
        }
        
        const docId = this.getAttribute('data-docid');
        const signatureData = signaturePad.toDataURL();
        
        // Mostrar vista previa
        document.getElementById('signature-preview').innerHTML = 
            `<img src="${signatureData}" style="max-width: 200px; border: 1px solid #ccc; border-radius: 5px;">`;
        
        // Enviar al servidor
        fetch('save_signature.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: `docId=${docId}&signature=${encodeURIComponent(signatureData)}`
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Firma guardada exitosamente. El documento firmado está listo para descargar.');
                window.location.href = `download.php?id=${docId}`;
            } else {
                alert('Error al guardar la firma: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Ocurrió un error al procesar la firma.');
        });
    });
});