<?php
include 'config.php';
require_once 'vendor/autoload.php'; // Requiere Composer y PDFLib

// Verificar si se recibieron los datos
if (!isset($_POST['docId']) || !isset($_POST['signature'])) {
    die(json_encode(['success' => false, 'message' => 'Datos incompletos']));
}

$docId = $_POST['docId'];
$signatureData = $_POST['signature'];

// Obtener información del documento
$stmt = $db->prepare("SELECT * FROM documents WHERE id = ?");
$stmt->execute([$docId]);
$document = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$document) {
    die(json_encode(['success' => false, 'message' => 'Documento no encontrado']));
}

try {
    // Crear versión firmada del PDF
    $pdf = new \setasign\Fpdi\Fpdi();
    
    // Importar página del PDF original
    $pageCount = $pdf->setSourceFile($document['file_path']);
    $templateId = $pdf->importPage(1);
    $size = $pdf->getTemplateSize($templateId);
    
    // Crear nueva página
    $pdf->AddPage($size['orientation'], [$size['width'], $size['height']]);
    $pdf->useTemplate($templateId);
    
    // Procesar imagen de la firma
    $signature = tempnam(sys_get_temp_dir(), 'sig');
    file_put_contents($signature, file_get_contents($signatureData));
    
    // Posicionar firma en el documento (abajo a la derecha)
    $x = $size['width'] - 100; // 100px desde el borde derecho
    $y = $size['height'] - 50; // 50px desde el borde inferior
    
    // Insertar firma en el PDF
    $pdf->Image($signature, $x, $y, 80, 40, 'PNG');
    unlink($signature); // Eliminar archivo temporal
    
    // Guardar PDF firmado
    $signedPath = SIGNED_DIR . 'signed_' . basename($document['file_path']);
    $pdf->Output('F', $signedPath);
    
    // Actualizar base de datos
    $update = $db->prepare("UPDATE documents SET signed_path = ?, status = 'signed', signed_at = NOW() WHERE id = ?");
    $update->execute([$signedPath, $docId]);
    
    echo json_encode(['success' => true]);
    
} catch (Exception $e) {
    die(json_encode(['success' => false, 'message' => $e->getMessage()]));
}
?>